<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = $icon_html = $icon_css = $data = '';

extract( shortcode_atts( array(
	'style' => 'background',
	'width' => '60',
	'height' => '60',
	'rounded' => '',
	'icon_color' => '',
	'background_color' => '',
	'border_color' => '',
	'border_width' => '',
	'border_style' => 'solid',
	'icon_color_hover' => '',
	'background_color_hover' => '',
	'border_color_hover' => '',
	'margin' => '',
	'icon_type' => '',
	'icon' => '',
	'icon_font_size' => '',
	'icon_line_height' => '',
	'link_url' => '',
	'new_tab' => 'yes'
), $atts ) );

$rand = rand();
$width = intval( $width );
$height = intval( $height );
$rounded = intval( $rounded );
$border_width = intval( $border_width );
$icon_font_size = intval( $icon_font_size );
$icon_line_height = intval( $icon_line_height );

$icon = conceptseven_get_icon_class( $atts, 'icon' );
vc_icon_element_fonts_enqueue( $icon_type );

$cls = 'icon-'. $rand;
if ( $icon_font_size ) $icon_css .= 'font-size:'. $icon_font_size .'px;';
if ( $width ) $icon_css .= 'width:'. $width .'px;';
if ( $height ) $icon_css .= 'height:'. $height .'px;';
if ( $border_style ) $icon_css .= 'border-style:'. $border_style .';';
if ( $border_width ) $icon_css .= 'border-width:'. $border_width .'px;';
if ( $rounded ) $icon_css .= 'border-radius:'. $rounded .'px;';
if ( $icon_line_height ) $icon_css .= 'line-height:'. $icon_line_height .'px;';
if ( $margin ) $icon_css .= 'margin:'. $margin .';';

if ( $icon_color ) $data .= ' data-icon="'. $icon_color .'"';
if ( $background_color ) $data .= ' data-background="'. $background_color .'"';
if ( $border_color ) $data .= ' data-border="'. $border_color .'"';

if ( $background_color_hover ) $data .= ' data-background-hover="'. $background_color_hover .'"';
if ( $border_color_hover ) $data .= ' data-border-hover="'. $border_color_hover .'"';
if ( $icon_color_hover ) $data .= ' data-icon-hover="'. $icon_color_hover .'"';

$icon_html = sprintf(
	'<span class="icon" style="%2$s"><i class="%1$s"></i></span>',
	$icon,
	$icon_css
);

if ( $link_url ) {
	$new_tab == 'yes' ? '_blank' : '_self';

	$icon_html = sprintf(
		'<a class="url-wrap" target="%3$s" href="%2$s">%1$s</a>',
		$icon_html,
		$link_url,
		$new_tab
	);
}

printf(
	'<div class="conceptseven-icon %2$s" %3$s>%1$s</div>',
	$icon_html,
	$cls,
	$data
);